/*Balang iin kaynaklar oluturun:

bash
Copy code
./program init
reticiyi balatn:

bash
Copy code
./program producer
Tketiciyi balatn:

bash
Copy code
./program consumer
Program tamamlandktan sonra kaynaklar temizleyin:

bash
Copy code
./program cleanup*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <sys/wait.h>
#include <string.h>
#define BUFFER_SIZE 10 // Tampon boyutu
#define SHM_KEY 1234   // Paylalan bellek anahtar
#define SEM_KEY 5678   // Semafor grubu anahtar

// Semafor ilemleri
void sem_wait(int sem_id, int sem_num) {
    struct sembuf sb = {sem_num, -1, 0};
    semop(sem_id, &sb, 1);
}

void sem_signal(int sem_id, int sem_num) {
    struct sembuf sb = {sem_num, 1, 0};
    semop(sem_id, &sb, 1);
}

// retici fonksiyonu
void producer() {
    int shm_id = shmget(SHM_KEY, (BUFFER_SIZE + 2) * sizeof(int), 0666); // Paylalan bellee balan
    int sem_id = semget(SEM_KEY, 2, 0666); // Semafor grubuna balan
    int *buffer = shmat(shm_id, NULL, 0); // Paylalan bellee balan
    int *in = &buffer[BUFFER_SIZE];       // reticinin yazma pozisyonu
    *in = 0;

    for (int i = 0; i < 20; i++) { // 20 e ret
        sem_wait(sem_id, 0); // Bo yer var m? (empty)
        buffer[*in] = rand() % 100; // Rastgele bir say ret
        printf("retici: %d ekledi (pozisyon: %d)\n", buffer[*in], *in);
        *in = (*in + 1) % BUFFER_SIZE; // Pozisyonu gncelle
        sem_signal(sem_id, 1); // rn mevcut (full)
        sleep(1);
    }
    shmdt(buffer); // Paylalan bellek balantsn kes
}

// Tketici fonksiyonu
void consumer() {
    int shm_id = shmget(SHM_KEY, (BUFFER_SIZE + 2) * sizeof(int), 0666); // Paylalan bellee balan
    int sem_id = semget(SEM_KEY, 2, 0666); // Semafor grubuna balan
    int *buffer = shmat(shm_id, NULL, 0); // Paylalan bellee balan
    int *out = &buffer[BUFFER_SIZE + 1];  // Tketicinin okuma pozisyonu
    *out = 0;

    for (int i = 0; i < 20; i++) { // 20 e tket
        sem_wait(sem_id, 1); // rn var m? (full)
        int item = buffer[*out];
        printf("Tketici: %d tketti (pozisyon: %d)\n", item, *out);
        *out = (*out + 1) % BUFFER_SIZE; // Pozisyonu gncelle
        sem_signal(sem_id, 0); // Bo yer ald (empty)
        sleep(1);
    }
    shmdt(buffer); // Paylalan bellek balantsn kes
}

int main(int argc, char *argv[]) {
    if (argc != 2) {
        printf("Kullanm: %s <producer|consumer>\n", argv[0]);
        return 1;
    }

    if (strcmp(argv[1], "producer") == 0) {
        // retici
        producer();
    } else if (strcmp(argv[1], "consumer") == 0) {
        // Tketici
        consumer();
    } else if (strcmp(argv[1], "init") == 0) {
        // Paylalan bellek ve semaforlar olutur
        int shm_id = shmget(SHM_KEY, (BUFFER_SIZE + 2) * sizeof(int), IPC_CREAT | 0666);
        int sem_id = semget(SEM_KEY, 2, IPC_CREAT | 0666);

        // Semafor balang deerlerini ayarla
        semctl(sem_id, 0, SETVAL, BUFFER_SIZE); // empty = BUFFER_SIZE
        semctl(sem_id, 1, SETVAL, 0);          // full = 0

        printf("Paylalan bellek ve semaforlar oluturuldu.\n");
    } else if (strcmp(argv[1], "cleanup") == 0) {
        // Kaynaklar temizle
        int shm_id = shmget(SHM_KEY, (BUFFER_SIZE + 2) * sizeof(int), 0666);
        int sem_id = semget(SEM_KEY, 2, 0666);

        shmctl(shm_id, IPC_RMID, NULL); // Paylalan bellei sil
        semctl(sem_id, 0, IPC_RMID);   // Semafor grubunu sil

        printf("Paylalan bellek ve semaforlar silindi.\n");
    } else {
        printf("Geersiz seenek: %s\n", argv[1]);
        return 1;
    }

    return 0;
}

